This README.md file template was generated on 2022-04-19 by Claudiu Forgaci and Adele Therias according to the 4TU.ResearchData [Guidelines for creating a README file](https://data.4tu.nl/info/en/use/publish-cite/upload-your-data-in-our-data-repository) and the Cornell University template [Guide to writing "readme" style metadata](https://cornell.app.box.com/v/ReadmeTemplate).

# Pattern Catalogue Every Drop Counts Dataset

## Table of Contents

- [1. GENERAL INFORMATION](#1-general-information)
- [2. METHODOLOGICAL INFORMATION](#2-methodological-information)
  - [2.1 Research questions, methods and envisioned uses](#21-research-questions-methods-and-envisioned-uses)
  - [2.2 Methods for processing the data](#22-methods-for-processing-the-data)
  - [2.3 Instrument- or software-specific information](#23-instrument--or-software-specific-information)
- [3. FILE OVERVIEW](#3-file-overview)
  - [3.1 File List](#31-file-list)
  - [3.2 Relationship between files](#32-relationship-between-files)
  - [3.3 File formats and naming conventions](#33-file-formats-and-naming-conventions)
- [4. DATA-SPECIFIC INFORMATION](#4-data-specific-information)
  - [4.1 Patterns data](#41-data-category-a)
- [5. SHARING/ACCESS INFORMATION](#5-sharingaccess-information)
  - [5.1 Licenses/restrictions placed on the data](#51-licensesrestrictions-placed-on-the-data)
  - [5.2 Links to other resources](#52-links-to-other-resources)
  - [5.3 Recommended citation for this dataset](#57-recommended-citation-for-this-dataset)


# 1. GENERAL INFORMATION

## 1.1 Title of Dataset
Pattern Catalogue Every Drop Counts Dataset

## 1.2 Dataset description
This dataset contains qualitative data created to give an overview of the applicable drought measures in the context of the Rhine. This dataset is part of a graduation thesis for the Master of Urbanism at Technical University Delft. Additional details about the project can be accessed [here](http://resolver.tudelft.nl/uuid:23dc6fe1-802d-40cf-bdaf-ac6e6fcbf9bd).

## 1.3 Author Information
A. Principal Investigator  
- Name: Anna van den Berg
- Institution: Technical University Delft
- Address: Julianalaan 134, 2628BL Delft, South-Holland, The Netherlands
- Email: anna.berg@xs4all.nl

B. Associate or Co-investigator
- Name: Kristel Aalbers
- Institution: Technical University Delft
- Address: Julianalaan 134, 2628BL Delft, South-Holland, The Netherlands
- Email: K.P.M.Aalbers@tudelft.nl

C. Associate or Co-investigator
- Name: Claudiu Forgaci 
- Institution: Technical University Delft
- Address: Julianalaan 134, 2628BL Delft, South-Holland, The Netherlands
- Email: C.Forgaci@tudelft.nl

## 1.4 Dates of data collection
- Survey 1: 2022 - 2023

## 1.5 Geographic location of data collection
Rhine Catchment Basin

## 1.6 Keywords
Drought, Rhine river, Green-blue infrastructure, Climate adaptation, Nature-based solutions

## 1.7 Language
English

## 1.8 Information about funding sources that supported the collection of the data
N/A

# 2. METHODOLOGICAL INFORMATION
## 2.1 Research questions, methods and envisioned uses
The dataset of European Commission and Office International de l’Eau (2014) was used to create a base for nature-based solutions that can be used as drought-mitigating strategies. This dataset was translated into a set of cards with background data to provide a overview. On the dataset of European Commission and Office International de l’Eau (2014) a way to select the appropriate drought-mitigating strategies for the design site was build. For this, visualisations of the dataset have been made.  

### 2.1.1 Research question 1: How can nature-based solutions be used for drought-mitigating strategies along the Rhine?
- Qualitative data collected through literature review and case studies. 

### 2.1.3 Envisioned uses of the dataset
- The dataset gives insight in the applicability of different nature-based solutions to mitigate drought in different design sites. 
- The dataset gives a method for simplifying the choice in different measures that are applicable on locations. 

## 2.2 Methods for processing the data
- Data files were reorganised in excel and combined into one file. 
- 'Yes' was translated into 2; 'Possible' into 1; 'No' into 0
- 'High' translated into 3; 'Medium' into 2; 'Low' into 1; 'None' into 0
- The main categories, given by the European Commission and Office International de l’Eau (2014), were combined into physical impacts and changes in the environment as selective categories. 
- The selective categories were used to create five filters between the different measures: Geomorphology; Branch of the river; Placement along the River; Land use; and Implementation scale.

## 2.3 Instrument- or software-specific information
N/A

# 3. FILE OVERVIEW
Are there multiple versions of the dataset? 

No

## 3.1 File List

- dataset_patterns.xlsx
- patterns_overview.pdf
- extended_patterns.pdf

### 3.1.1 Dataset Patterns
- "dataset_patterns.xlsx": table with drought mitigating measures with suitability scores generated from literature review

### 3.1.2 Patterns Overview
- "pattern_overview.pdf": illustrated representation of drought mitigating measures

### 3.1.3 Extended Patterns
- "exteded_patterns.pdf": illustrated examples of drought mitigating measures

## 3.2 Relationship between files:
The following table (xlsx files) employs a foreign key to refer to the primary key (unique identifier) in the other (pdf) file(s):

"dataset_patterns.xlsx"
- ID used as foreign key to "patterns_overview.pdf"
- ID used as foreign key to "extended_patterns.pdf"

## 3.3 File formats and naming conventions
### 3.3.1 File formats
- xlsx - tabular data
- pdf - complex templates and base maps including images or vector-based illustrations and text

### 3.3.2 Naming conventions
- files named lower case, spaces replaced with underscores (snake-case)
- in tabular data, variable names snake case

# 4. DATA-SPECIFIC INFORMATION

- Missing data code: empty cell in xlsx tables
- Not Applicable: N/A

## 4.1 Patterns data

### 4.1.1 dataset_patterns.xlsx
1. Number of variables: 80

2. Number of cases/rows: 53

3. Variable List:

Based on European Commission and Office International de l’Eau (2014)

"name_measure"
- Full name: Name measure 
- Description: Name of the measure
- Type of variable: String
- Unit of measurement: N/A
- Number of missing values: 0

"ID"
- Full name: Identification number
- Description: Number to identify the measure
- Type of variable: String
- Unit of measurement: N/A
- Number of missing values: 0

"artificial_surfaces"
- Full name: Artificial surfaces
- Description: Suitable for land-use type artificial surfaces
- Type of variable: Categorical, Nominal
- Unit of measurement: 2 - Yes
                       1 - Possible
                       0 - No
- Number of missing values: 0

"agricultural_areas"
- Full name: Agricultural areas
- Description: Suitable for land-use type agricultural areas
- Type of variable: Categorical, Nominal
- Unit of measurement: 2 - Yes
                       1 - Possible
                       0 - No
- Number of missing values: 0

"forests_and_semi-natural_areas"
- Full name: Forests and semi-natural areas
- Description: Suitable for land-use type forests and semi-natural areas
- Type of variable: Categorical, Nominal
- Unit of measurement: 2 - Yes
                       1 - Possible
                       0 - No
- Number of missing values: 0

"wetlands"
- Full name: Wetlands
- Description: Suitable for land-use type wetlands
- Type of variable: Categorical, Nominal
- Unit of measurement: 2 - Yes
                       1 - Possible
                       0 - No
- Number of missing values: 0

"western_europe"
- Full name: Western Europe
- Description: Suitable for region Western Europe
- Type of variable: Categorical, Nominal
- Unit of measurement: 2 - Yes
                       1 - Possible
                       0 - No
- Number of missing values: 0

"mediterranean"
- Full name: Mediterranean
- Description: Suitable for region Mediterranean
- Type of variable: Categorical, Nominal
- Unit of measurement: 2 - Yes
                       1 - Possible
                       0 - No
- Number of missing values: 0

"baltic_sea"
- Full name: Baltic Sea
- Description: Suitable for region Baltic Sea
- Type of variable: Categorical, Nominal
- Unit of measurement: 2 - Yes
                       1 - Possible
                       0 - No
- Number of missing values: 0

"eastern_europe_and_danube"
- Full name: Eastern Europe and Danube
- Description: Suitable for region Eastern Europe and Danube
- Type of variable: Categorical, Nominal
- Unit of measurement: 2 - Yes
                       1 - Possible
                       0 - No
- Number of missing values: 0

"0-0,1_km2"
- Full name: 0-0,1 km2
- Description: Scale of measure between 0 - 0,1 km2
- Type of variable: Categorical, Nominal
- Unit of measurement: 2 - Yes
                       1 - Possible
                       0 - No
- Number of missing values: 0

"0,1-1,0_km2"
- Full name: 0,1-1,0 km2
- Description: Scale of measure between 0,1 - 1,0 km2
- Type of variable: Categorical, Nominal
- Unit of measurement: 2 - Yes
                       1 - Possible
                       0 - No
- Number of missing values: 0

"1,0-10_km2"
- Full name: 1,0-10 km2
- Description: Scale of measure between 1,0 - 10 km2
- Type of variable: Categorical, Nominal
- Unit of measurement: 2 - Yes
                       1 - Possible
                       0 - No
- Number of missing values: 0

"10-100_km2"
- Full name: 10-100 km2
- Description: Scale of measure between 10 - 100 km2
- Type of variable: Categorical, Nominal
- Unit of measurement: 2 - Yes
                       1 - Possible
                       0 - No
- Number of missing values: 0

"100-1000_km2"
- Full name: 100-1000 km2
- Description: Scale of measure between 100 - 1000 km2
- Type of variable: Categorical, Nominal
- Unit of measurement: 2 - Yes
                       1 - Possible
                       0 - No
- Number of missing values: 0

">1000_km2"
- Full name: >1000 km2
- Description: Scale of measure between >1000 km2
- Type of variable: Categorical, Nominal
- Unit of measurement: 2 - Yes
                       1 - Possible
                       0 - No
- Number of missing values: 0

"store_run-off"
- Full name: Store run-off
- Description: Effectiveness of measure on slowing & storing run-off 
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"slow_run-off"
- Full name: Slow run-off
- Description: Effectiveness of measure on slowing & storing run-off 
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"store_river_water"
- Full name: Store river water
- Description: Effectiveness of measure on slowing & storing run-off 
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"slow_river_water"
- Full name: Slow river water
- Description: Effectiveness of measure on slowing & storing run-off 
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"increase_evapotranspiration"
- Full name: Increase evapotranspiration
- Description: Effectiveness of measure on reducing run-off
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"increase_infiltration_and/or_groundwater_recharge"
- Full name: Increase infiltration and/or groundwater recharge
- Description: Effectiveness of measure on reducing run-off
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"increase_soil_water_retention"
- Full name: Increase soil water retention
- Description: Effectiveness of measure on reducing run-off
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"reduce_pollutant_sources"
- Full name: Reduce pollutant sources
- Description: Effectiveness of measure on reducing pollution
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"intercept_pollution_pathways"
- Full name: Intercept pollution pathways
- Description: Effectiveness of measure on reducing pollution
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"reduce_erosion_and/or_sediment_delivery"
- Full name: Reduce erosion and/or sediment delivery
- Description: Effectiveness of measure on soil conservation
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"improve_soils"
- Full name: Improve soils 
- Description: Effectiveness of measure on soil conservation
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"create_aquatic_habitat"
- Full name: Create aquatic habitat
- Description: Effectiveness of measure on creating habitat
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"create_riparian_habitat"
- Full name: Create riparian habitat
- Description: Effectiveness of measure on creating habitat
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"create_terrestrail_habitat"
- Full name: Create terrestrial habitat
- Description: Effectiveness of measure on creating habitat
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"enhance_precipitation"
- Full name: Enhance precipitation
- Description: Effectiveness of measure on climate alteration
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"reduce_peak_temperature"
- Full name: Reduce peak temperature
- Description: Effectiveness of measure on climate alteration
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"absorb_and/or_retain_CO2"
- Full name: Absorb and/or retain CO2
- Description: Effectiveness of measure on climate alteration
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"food_provision"
- Full name: Food provision
- Description: Effectiveness of measure on provisioning
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"water_storage"
- Full name: Water storage
- Description: Effectiveness of measure on provisioning
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"fish_stocks_and_recruiting"
- Full name: Fish stocks and recruiting
- Description: Effectiveness of measure on provisioning
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"natural_biomass_production"
- Full name: Natural biomass production
- Description: Effectiveness of measure on provisioning
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"biodiversity_preservation"
- Full name: Biodiversity preservation
- Description: Effect of measure on regulatory and maintenance
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"groundwater/aquifer_recharge"
- Full name: Groundwater/aquifer recharge
- Description: Effect of measure on regulatory and maintenance
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"flood_risk_reduction"
- Full name: Flood risk reduction
- Description: Effect of measure on regulatory and maintenance
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"erosion/sediment_control"
- Full name: Erosion/sediment control
- Description: Effect of measure on regulatory and maintenance
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"filtration_of_pollutants"
- Full name: Filtration of pollutants
- Description: Effect of measure on regulatory and maintenance
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"recreational_opportunities"
- Full name: Recreational opportunities
- Description: Effect of measure on cultural
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"aesthetic/cultural_value"
- Full name: Aesthetic/cultural value
- Description: Effect of measure on cultural
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"navigation"
- Full name: Navigation
- Description: Effect of measure on abiotic
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"geological_resources"
- Full name: Geological resources
- Description: Effect of measure on abiotic
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"energy_production"
- Full name: Energy production
- Description: Effect of measure on abiotic
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

Added by author

"infiltration_capacity"
- Full name: Infiltration capacity
- Description: Effectiveness of measure on physical impact
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"water_storage"
- Full name: Water storage
- Description: Effectiveness of measure on physical impact
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"run-off"
- Full name: Run-off
- Description: Effectiveness of measure on physical impact
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"pollutant_reduction"
- Full name: Pollutant reduction
- Description: Effectiveness of measure on physical impact
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"improve_soil"
- Full name: Improve soil
- Description: Effectiveness of measure on physical impact
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"aquifer_recharge"
- Full name: Aquifer recharge
- Description: Effectiveness of measure on physical impact
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"range"
- Full name: Range
- Description: Effectiveness of measure on changes in environment
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"drought_prevention"
- Full name: Drought prevention
- Description: Effectiveness of measure on changes in environment
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"sponge_working"
- Full name: Sponge working
- Description: Effectiveness of measure on changes in environment
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"mitigation"
- Full name: Mitigation
- Description: Effectiveness of measure on changes in environment
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"biodiversity"
- Full name: Biodiversity
- Description: Effectiveness of measure on changes in environment
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"flood_prevention"
- Full name: Flood prevention
- Description: Effectiveness of measure on changes in environment
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"type_1"
- Full name: Geomorphology type 1
- Description: Applicability of the measure on geomorphology type
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"type_2"
- Full name: Geomorphology type 2
- Description: Applicability of the measure on geomorphology type
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"type_3"
- Full name: Geomorphology type 3
- Description: Applicability of the measure on geomorphology type
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"type_4"
- Full name: Geomorphology type 4
- Description: Applicability of the measure on geomorphology type
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"type_5"
- Full name: Geomorphology type 5
- Description: Applicability of the measure on geomorphology type
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"type_6"
- Full name: Geomorphology type 6
- Description: Applicability of the measure on geomorphology type
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"type_7"
- Full name: Geomorphology type 7
- Description: Applicability of the measure on geomorphology type
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"type_8"
- Full name: Geomorphology type 8
- Description: Applicability of the measure on geomorphology type
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"main_branch"
- Full name: Main branch of the river
- Description: Applicability of the measure on branch of the river
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"tributaries"
- Full name: Tributaries of the river
- Description: Applicability of the measure on branch of the river
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"delta"
- Full name: Delta along the river
- Description: Applicability of the measure on placement along the river
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"middle"
- Full name: Middle along the river
- Description: Applicability of the measure on placement along the river
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"headwater"
- Full name: Headwater along the river
- Description: Applicability of the measure on placement along the river
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"agriculture"
- Full name: Agriculture along the river
- Description: Applicability of the measure on land-use
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"wetland"
- Full name: Wetland along the river
- Description: Applicability of the measure on land-use
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"forest"
- Full name: Wetland along the river
- Description: Applicability of the measure on land-use
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"artificial"
- Full name: Wetland along the river
- Description: Applicability of the measure on land-use
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"small"
- Full name: Small scale
- Description: Applicability of the measure of implementation scale
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"medium"
- Full name: Medium scale
- Description: Applicability of the measure of implementation scale
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

"large"
- Full name: Large scale
- Description: Applicability of the measure of implementation scale
- Type of variable: Categorical, Nominal
- Unit of measurement: 3 - High
                       2 - Medium
                       1 - Low
                       0 - None
- Number of missing values: 0

4. Specialised formats or other abbreviations used: N/A

5. Total file size: 40kb

### 4.1.2 patterns_overview.pdf

1. Number of cases: 53

2. Purpose: Give an overview of the measures that link to the excel file. When printed and cut out, this set can be used to sort the different data types. By creating open and closed slits in the cards where a stick can sort between the different steps. 

3. Specialised formats or other abbreviations used: N/A

4. Total file size: 1.4mb

### 4.1.2 extended_patterns.pdf

1. Number of cases: 14

2. Purpose: Gives an overview of the data for the measures shown in patterns_overview.pdf. These patterns can be used to give a more in depth explanation of the measure.

3. Specialised formats or other abbreviations used: N/A

4. Total file size: 51.5mb


# 5. SHARING/ACCESS INFORMATION
## 5.1 Licenses/restrictions placed on the data:
CC BY-SA 4.0

## 5.2 Links to other resources:
N/A

### 5.2.1 Links to publications that cite or use the data:
N/A 

### 5.2.2 Links to other publicly accessible locations of the data: 

http://resolver.tudelft.nl/uuid:23dc6fe1-802d-40cf-bdaf-ac6e6fcbf9bd

### 5.2.3 Links/relationships to ancillary data sets: 
N/A

### 5.2.4 Links to publicly accessible scripts for analysis of the dataset:
N/A

### 5.2.5 Was data derived from another source?
Yes, as described in 2.2 Methods for processing the data and 4.1.1 dataset_patterns.xlsx

European Commission, & Office International de l’Eau. (2014). Pilot Project - Atmospheric Precipitation - Protection and efficient use of Fresh Water: Integration of Natural Water Retention Measures in River Basin Management. Retrieved 14 March from http://nwrm.eu/index.php/measures-catalogue

## 5.3 Recommended citation for this dataset:

Van den Berg, A., Aalbers, K., Forgaci, C. (2023). Pattern Catalogue Every Drop Counts Dataset. Retrieved from  10.4121/03e4f197-c823-4044-862a-1e79ff1be2a1
